# -------------------------------------------------------------------
# pat_winlink_pi_install.sh
#
# Install script that installs Pat Winlink on a Raspberry Pi
# Copyright 2025 n1spw@tuta.com
# License: Attribution-ShareAlike 4.0 International
#                 (CC BY-SA 4.0)
# https://creativecommons.org/licenses/by-sa/4.0/legalcode
#
# Use this script at your own risk! No warranty of any kind provided.
#
# Contact information:
# http://n1spw.net
# n1spw@tuta.com
#
# Version 1.0 - 2025-08-02
# -------------------------------------------------------------------
#! /bin/bash

# Script functions.
exit_error() {
    echo "====================================================================================="
    echo "--- This script did not complete successfully. Check error messages and edit script."
    echo "--- Error message: $1"
    echo "====================================================================================="
    exit 1
}

print_success() {
    echo "============================================="
    echo "|   Install script completed successfully.  |"
    echo "============================================="
    echo ""
    echo "Please reboot the Pi to enable the new settings."
    exit 0
}

echo "============================================="
echo "|      Checking for required files.         |"
echo "============================================="

cd ~/
FILE=files.txt
if test -f "$FILE"; then
    :
else
    exit_error "--- Required file files.txt not found."
fi

for REQ_FILE in $(cat files.txt)
do
    if test -f "$REQ_FILE"; then
        :
    else
        exit_error "--- Required file $REQ_FILE not found."
    fi
done

echo "+++ All required files found..."
echo

echo "============================================="
echo "|               Upgrading OS.               |"
echo "============================================="
sudo apt update
if [ $? -ne 0 ]; then
	exit_error "--- Error upgrading OS."
fi

sudo apt upgrade -y
if [ $? -ne 0 ]; then
    exit_error "--- Error upgrading OS."
else
	echo "+++ OS upgraded."
fi
echo ""

echo "============================================="
echo "|        Installing required apps.          |"
echo "============================================="

for APP in $(cat apps.txt)
do
    echo ""
    echo "Installing $APP..."
    sudo apt install -y $APP
    if [ $? -ne 0 ]; then
        exit_error "--- Error installing $APP."
    else
        echo "+++ $APP successfully installed."
    fi
    echo ""
done

echo "============================================="
echo "|        Installing direwolf...             |"
echo "============================================="
cd ~
git clone https://www.github.com/wb2osz/direwolf
if [ $? -ne 0 ]; then
    exit_error "--- Error downloading direwolf from Internet."
else
	echo "+++ direwolf downloaded."
fi

cd direwolf
mkdir build && cd build
if [ $? -ne 0 ]; then
    exit_error "--- Error creating direwolf build directory."
fi

cmake ..
if [ $? -ne 0 ]; then
    exit_error "--- cmake error configuring direwolf."
fi

make -j4
if [ $? -ne 0 ]; then
    exit_error "--- make error building direwolf."
fi

sudo make install
if [ $? -ne 0 ]; then
    exit_error "--- Error installing direwolf."
fi

make install-conf
if [ $? -ne 0 ]; then
    exit_error "--- Error creating default direwolf configuration."
fi

echo "+++ direwolf installed successfully."

echo ""
echo "============================================="
echo "|        Installing PAT Winlink..           |"
echo "============================================="
cd Downloads
wget https://github.com/la5nta/pat/releases/download/v0.16.0/pat_0.16.0_linux_armhf.deb
if [ $? -ne 0 ]; then
    exit_error "--- Error downloading PAT Winlink."
fi

sudo dpkg -i pat_0.16.0_linux_armhf.deb
if [ $? -ne 0 ]; then
    exit_error "--- Error installing PAT Winlink."
fi

cd ~/
echo
echo
print_success
